import com.dynamicflash.utils.Delegate;
//importuji třídu pro vytváření událostí 

class JungleGame extends MovieClip
{
  var _numAnimals: Number; 

  function JungleGame ()
  {

    init ();
  }

  function init ()
  {
    //ukážeme kursor myši
    Mouse.show();

    //umístíme startovací tlačítko
    this.attachMovie ("StartButton", "_startButton", this.getNextHighestDepth()  );
    this["_startButton"]._x= 200;
    this["_startButton"]._y= 300;

    //Vytvoříme titulku 
    this.createTextField("_title",this.getNextHighestDepth(),0,0,Stage.width,200);

    var tf = new TextFormat();
    tf.font = "badaboom";
    tf.size = 80;
    tf.color = "0xffcc00";


    this["_title"].text =  "VYSTŘÍLEJ PRALES!" ;
    this["_title"].embedFonts = true;
    this["_title"].selectable = false;
    this["_title"].setTextFormat ( tf );
    this["_title"]._x = 50;
    this["_title"]._y = 100;

    //Vytvořím událost při stisknutí tlačítka
    var myGame = this["_startButton"].onRelease = Delegate.create(this, startGame);
    myGame._numElephants = 6;
    myGame._numHippo = 6;
  }     

  private function startGame () : Void
  {
    //Hra začíná - smažu pvodní obrazovku

    this["_startButton"].removeMovieClip();
    this["_title"].removeTextField();

    //Načtu hodnoty pro počet objektů na obrazovce 
    var _numElephants = arguments.caller._numElephants;
    var _numHippo = arguments.caller._numHippo;

    _numAnimals = _numElephants + _numHippo;

    //Vytvořím slony
    for ( var i = 0; i < _numElephants; i++ )
    {
      this.attachMovie ("Slon", "_slon" + i,this.getNextHighestDepth() );

    }

    //Vytvořím hrochy   
    for ( var i = 0; i < _numHippo; i++ )
    {
      this.attachMovie ("Hroch", "_hroch" + i, this.getNextHighestDepth()  );

    }

    //Schovám myš a zobrazím zaměřovač 
    Mouse.hide();
    this.attachMovie ("Pointer", "_pointer", this.getNextHighestDepth() );

  }


  function onMouseDown () {
    //Při stisku myši zkontroluji, zda se mi zaměóvač nepřekrývá s nějakým objektem
    //Zároveň počítám
    for(var i in this ){
      if (this[i] instanceof Objekt ) {

        if (this["_pointer"].hitTest(this[i])) {
          this[i].removeMovieClip();
          _numAnimals = _numAnimals - 1;

//Jestliže už nezbývá žádné zvíře 
          if (_numAnimals == 0 ) {
            this["_pointer"].removeMovieClip();
            init ();  


          }

        }
      }


    }



  }

}
