import flash.MovieClip;
import flash.Sound;
import events.Event;
import LibraryClasses;
import Song;

class MPPlayer extends MovieClip
{	

  static var sound		: Sound;
  static var isPlaying	: Bool;
  static var isLoaded		: Bool;
  static var offset		: Float;
  static var currentSong: Int;
  static var songs: Array<Song>;

  static function playSong(song:Song)
  {

    if (!isLoaded) 
    {
      //Pokud není žádná mp3 nahraná, nahrajeme novou 
      sound = new Sound( );
      sound.onSoundComplete = function()
      {
        //Pokud mp3 dohrála, spustíme funkci pro přeskočení na další položku v playlistu
        isPlaying = !isPlaying;
        forward ();
      }
      flash.Lib.current.mcTxt.txt.text = song.artist + ": " + song.title;
      //V haXe přistupujeme k objektům nikoliv přes _root.atd, ale přes flash.Lib.current, v našem případě zadáme hodnotu pro proměnou text u textového objektu "txt"
      sound.loadSound( song.source, true );
      isLoaded = true;
    }

    sound.start( offset );
    isPlaying = !isPlaying;


  }

  static function pause()
  {
    if (isPlaying)
    {
      //Pauza = zaznamenám si pozici mp3 a zastavím ji
      offset = sound.position / 1000;
      sound.stop();
      isPlaying = !isPlaying;
    }
  }

  static function stopSong()
  {
    if (isPlaying)
    {
      //Stop = vynuluji pozici a zastavím mp3
      offset = 0;
      sound.stop();
      isPlaying = !isPlaying;
    }
  }

  static function forward()
  {
    if (isPlaying)
    {
      sound.stop();
      isPlaying = !isPlaying;
    }
    if (isLoaded) 
    {
      isLoaded = !isLoaded;
    }
    //Posunu se dál na playlistu
    if (currentSong == (songs.length - 1)) 
    {
      currentSong = 0;
    }
    else 
    {
      ++currentSong ;
    }
    //Pustím další mp3 na playlistu
    playSong (songs[currentSong]);

  }

  static function backward ()
  {
    if (isPlaying)
    {
      sound.stop();
      isPlaying = !isPlaying;
    }
    //Posunu se o jednu položku nazpět v playlistu
    if (currentSong == 0) 
    {
      currentSong = songs.length - 1;
    }
    else {
      currentSong = currentSong - 1 ;
    }
    if (isLoaded) 
    {
      isLoaded =  !isLoaded;
    }
    //Pustím předchozí mp3 na playlistu
    playSong (songs[currentSong]);

  }


  function initMPPlayer (importedSongs:Array<Song>) 
  {
    songs = importedSongs;

    //Připojím ovládací prvky 
    this.attachMovie("BtnStop","btnStop",this.getNextHighestDepth());
    this.attachMovie("BtnPlayPause","btnPlayPause",this.getNextHighestDepth());
    this.attachMovie("BtnFw","btnFw",this.getNextHighestDepth());
    this.attachMovie("BtnBw","btnBw",this.getNextHighestDepth());

    //Zaposlouchám se do událostí na ovládacích prvcích 
    this.btnPlayPause.addEventListener(CLICK, eventHandler,this);
    this.btnPlayPause.addEventListener(CLICK, eventHandler,this);
    this.btnStop.addEventListener(CLICK, eventHandler,this);
    this.btnFw.addEventListener(CLICK, eventHandler,this);
    this.btnBw.addEventListener(CLICK, eventHandler,this);
  }

  function parseXml (str:String) 
  {
    //Parsuji nahrané XML pomocí vlastní komponenty haxe.xml.Fast z haXe 
    var _xml:Xml=Xml.parse(str);
    var fast = new haxe.xml.Fast( _xml.firstElement());
    var songs = new Array();

    for(item in fast.elements)
    {
      var song = new Song();
      song.source = item.att.source;
      song.artist = item.att.artist;
      song.title = item.att.title;
      songs.push(song);
    }
    initMPPlayer(songs);

  }

  function eventHandler (event:Event) {

    switch (event.target.id) 
    {
      case "play":    
        if (!isPlaying) 
        {
          playSong (songs[currentSong]);
        }
        else 
        {
          pause();
        }
    
      case "stop":    
        if (isPlaying) 
        {
          //Jednoduchá animace - přepnu na políčko "play"
          this.btnPlayPause.gotoAndStop("play");
        }
        stopSong();

      case "forward":    
        if (!isPlaying) {
          //Jednoduchá animace - přepnu na políčko "pause"
          this.btnPlayPause.gotoAndStop("pause");}
        forward();

      case "backward":    
        if (!isPlaying) {
          //Jednoduchá animace - přepnu na políčko "pause"
          this.btnPlayPause.gotoAndStop("pause");}
          backward();
        }
    } 

  public function new ()
  {
  
    //Nastavím základní proměnné
    isPlaying = false;
    isLoaded = false;
    //Startovací pozice je 0 a také první píseň má pořadí 0
    offset = 0;
    currentSong = 0;
    
    //Nahrávám externí soubor pomocí komponenty haxe.Http
    var http:haxe.Http = new haxe.Http(flash.Lib.current.file);
    http.onStatus = function (n:Int) { trace("http status: " + n); }
    http.onError = function (msg:String) { trace(msg); }
    http.onData = parseXml;
    http.request(true);

  }

}

