
package events;

import events.Event;
import events.EventListener;

class EventDispatcher {
	private var listeners:Array<EventListener>;
	private var eventTarget:Dynamic;
	
	public function new(?eventTarget:Dynamic) {
		listeners = new Array();
		this.eventTarget = if(eventTarget) eventTarget else this; 
	}
	
	public function addEventListener(type:EventType, handler:Dynamic, context:Dynamic):Void {
		removeEventListener(type, handler, context);
		listeners.push(new EventListener(type, handler, context));
	}
	
	public function removeEventListener(type:EventType, handler:Dynamic, context:Dynamic):EventListener {
		var listener:EventListener = new EventListener(type, handler, context);
		for(i in 0...listeners.length) {
			if(listeners[i].equals(listener)) {
				return listeners.splice(i, 1)[0];
			}
		}
		return null;
	}
	
	public function dispatchEvent(event:Event):Bool {
		var type:EventType = event.type;
		var listener:EventListener;
		if(event.target == null) {
			untyped {event["target"] = eventTarget;}
		}
		for(i in 0...listeners.length) {
			listener = listeners[i];
			if(listener.type == type) {
				Reflect.callMethod(listener.context, listener.handler, [event]);
			}
		}
		return true;
	}
}
