#include "Commander.h"
#include "SysUtil.h"
#include "StrUtil.h"
#include "Search.h"

#include <stdio.h>
#include <stdlib.h>
#include <readline/readline.h>
#include <readline/history.h>

// hledac pro readline
Search *Commander::search = NULL;

//-----------------------------------------------------------------
/**
  Nastavi readline auto TAB na vlastni generator.
  Zaroven rekneme readline, aby nerozdelovala pri doplnovani fraze,
  ani kdyz mezi nima bude mezera.

FIXME: implementovat singleton navrhem
*/
Commander::Commander(Search *finder)
{
    Function **rlComp = (Function**)&rl_completion_entry_function;
    *rlComp = (Function*)Commander::slovicka_generator;
    rl_completer_word_break_characters = "";
    line = NULL;

    if (Commander::search != NULL) {
        SysUtil::error("Commander", "ambiguous vocabulary for readline");
    }
    else {
        Commander::search = finder;   
    }

    argLine = NULL;
}

//-----------------------------------------------------------------
/**
  Doplnovac slov pro readline.
  @param text slovicko pro doplneni
  @param state poradove cislo volani pro to same slovicko
  @return vraci vsechny slovicka zacinajici na text, na konci vrati NULL
  */
    char *
Commander::slovicka_generator(const char *text, int state)
{
    if (state == 0) {
        // prvni hledani
        return search->complete(text);
    }
    else {
        return search->nextComplete();
    }
}

//-----------------------------------------------------------------
/**
  Cteme, doplnime a vracime command line.
  */
    char *
Commander::runLine()
{

    if (line != NULL) {
        free(line);
    }

    // cteni prikazu
    if (argLine == NULL) {
        line = readline("wbook> ");
    }
    else {
        line = StrUtil::dupstr(argLine);
        argLine = NULL;
    }

    if (line == NULL) {
        printf("OK, bye.\n");
        exit(0);
    }

    // prazdnou radku nehistorujeme
    //FIXME: nehistorizovat ani posloupnost mezer
    if (*line != 0) {
        add_history(line);
    }

    return line;
}

//-----------------------------------------------------------------
/**
  Predurci nasledujici vracenou radku.
  */
    void
Commander::inputLine(const char *the_argLine)
{
    argLine = the_argLine;
}

