#include "Compare.h"
#include "SysUtil.h"

#include <stdio.h>
#include <string.h>

/**
  Ze souboru ctu radky.
  Znaky na stejne radce maji stejne ohodnoceni.
  Znaky na prvni radce maji ohodnoceni 1, 
  na druhe 2, ...
  Znaky co nejsou uvedeny maji ohodnoceni DEF_HODNOCENI = 255

  Jedina pochopitelna vyjimka:
  abeceda[0] = 0;
  tzv. kratsi retezec ma mensi ohodnoceni

NOTE: sizeof(abeceda) vraci 1024 namisto 256, proto pouzivam COUNT
*/
Compare::Compare(const char *filename)
{
    char buf[256];

    FILE *file = fopen(filename, "r");
    if (file == NULL) {
        SysUtil::systemError(filename);
    }

    // pocatecni ohodnoceni pro vsechny
    for (unsigned int i = 0; i < COUNT; i++) {
        abeceda[i] = DEF_HODNOCENI;
    }

    for(int radka = 0; fgets(buf, sizeof(buf), file); radka++) {
        for (char *p = buf; *p != '\n' && *p != '\0'; p++) { 
            abeceda[(unsigned char)*p] = radka;
        }
    }

    abeceda[0] = 0;
}	
//-----------------------------------------------------------------

/**
  Porovna dva retezce jako strcmp(),
  ale hodnoty znaku bere ze sve abecedy.

  Dokud zacinaji stejne retezce, hledej.
  Zaroven musime ale kontrolovat, abychom
  nepresli konec retezce (nedostali se mimo povolenou pamet).
  */
    int 
Compare::cmp(const char *a, const char *b)
{
    while (*a != '\0' && 
            abeceda[(unsigned char)*a] == abeceda[(unsigned char)*b]) {
        a++;
        b++;
    }

    return abeceda[(unsigned char)*a] - abeceda[(unsigned char)*b];
}


//-----------------------------------------------------------------
/**
  Informativne vypise abecedu.
  */
    void
Compare::print()
{
    //FIXME: ne moc prehledny vypis, vypisuje
    // serazene podle ascii hodnoty,
    // lepe podle ohodnoceni
    for (unsigned int i = 0; i < COUNT; i++) {
        printf("%3d: %c = %d\n", i, (char)i, abeceda[i]);
    }
}
