#include "Config.h"

#include "Options.h"
#include "SysUtil.h"

#include <stdio.h>
#include <stdlib.h>

//-----------------------------------------------------------------
/**
  Nastaveni opt.
  */
    Config::Config(Options *iopt)
: opt(iopt)
{
    short_options = opt->getShort();
#ifdef _GNU_SOURCE
    long_options = opt->getLong();
#endif
}
//-----------------------------------------------------------------
/**
  Uvolneni opt.
  */
Config::~Config()
{
    free(short_options);
#ifdef _GNU_SOURCE
    free(long_options);
#endif

    delete opt;
}

//-----------------------------------------------------------------
/**
  Vrati dalsi vyparsove params.
  */
    int 
Config::getNextVal(int argc, char * const argv[])
{
#ifdef _GNU_SOURCE
    return getopt_long(argc, argv, short_options, long_options, NULL);
#else
    return getopt(argc, argv, short_options);
#endif

}
//-----------------------------------------------------------------
/**
  Vypise help.
  */
    void
Config::printUsage(FILE *out) const
{
    fprintf(out, "Usage: %s [OPTION] [sentence]\n", SysUtil::getProgName());
    opt->printConfig(out);
}

