#include "Options.h"

#include "SysUtil.h"

#include <stdio.h>


//-----------------------------------------------------------------
/**
  Prazdne parametry.
  */
    Options::Options()
: params()
{
    shortlen = 0;
}

//-----------------------------------------------------------------
/**
  Zruseni pole parametru.
  */
Options::~Options()
{
    for (t_pars::iterator i = params.begin(); i < params.end(); i++) {
        delete (*i);
    }
}

//-----------------------------------------------------------------
/**
  Pridani parametru.
  */
    void
Options::addParam(Param *par)
{
    params.push_back(par);
    if (par->has_arg) {
        shortlen += 2;
    }
    else {
        shortlen++;
    }
}

//-----------------------------------------------------------------
/**
  Sestavime short_options 
  (vezmeme zacatecni znaky z dlouhych options).
  Pro has_arg == true pridame do short_opt ':'.
  */
    char *
Options::getShort() const
{
    char *short_options = (char *)SysUtil::xmalloc(shortlen + 1);

    int j = 0;
    for (t_pars::const_iterator i = params.begin(); i < params.end(); ++i) {
        short_options[j++] = (*i)->name[0];
        if ((*i)->has_arg) {
            short_options[j++] = ':';
        }
    }
    // zakonceni
    short_options[j] = '\0';

    //TEST: short_options
    SysUtil::log_debug("slen: %d", shortlen);
    SysUtil::log_debug("sopt: %s", short_options);

    return short_options;
}

//-----------------------------------------------------------------
/**
  Sestavime long_options.
  */
    option *
Options::getLong() const
{
    option *long_options = (option *)SysUtil::xmalloc((1 + params.size())
            * sizeof(option));

    int j = 0;
    for (t_pars::const_iterator i = params.begin(); i < params.end(); ++i) {
        long_options[j].name = (*i)->name;
        long_options[j].has_arg = (*i)->has_arg ? 1 : 0;
        long_options[j].flag = NULL;
        long_options[j].val = (*i)->name[0];
        j++;
    }

    // zakonceni
    long_options[j].name = NULL;
    long_options[j].has_arg = 0;
    long_options[j].flag = NULL;
    long_options[j].val = 0;

#ifdef DEBUG
    //TEST: long_options
    SysUtil::log_debug("long_len: %d", params.size());
    for (option *i = long_options; i->name != NULL; i++) {
        SysUtil::log_debug("long_opt: %s,\t%d, %p, %c", 
                i->name, i->has_arg, i->flag, (char)i->val);
    }
#endif

    return long_options;
}

//-----------------------------------------------------------------
/**
  Vypise help k jednotlivym parametrum.
  */
    void 
Options::printConfig(FILE *out) const
{
    for (t_pars::const_iterator i = params.begin(); i < params.end(); ++i) {
        Param *u = (*i);
        fprintf(out, "  -%c, --%-10s %-12s%s\n", u->name[0], u->name, 
                u->has_arg ? "arg" : "   ", u->usage);
    }
}

