#ifndef OPTIONS_H
#define OPTIONS_H

#include <stdio.h>
#include <getopt.h>
#include <vector>


/**
  Struktura pro predani zadani options pro parametry.
  */
struct Param {
    // jmeno option
    const char *name;
    // zda ocekavame argument 
    bool has_arg;
    // help
    const char *usage;

    Param(const char *iname, bool ihas_arg, const char *iusage) 
        : name(iname), has_arg(ihas_arg), usage(iusage)
        {}
};

typedef std::vector<Param *> t_pars;
//-----------------------------------------------------------------
/**
  Trida pro zakuleni prace s options.
  */
class Options {
    t_pars params;
    int shortlen;

    public:
    Options();
    ~Options();
    void addParam(Param *par);
    char *getShort() const;
    option *getLong() const;
    void printConfig(FILE *out) const;
};

#endif
