#include "Say.h"
#include "SysUtil.h"

#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <string.h>
#include <signal.h>

//-----------------------------------------------------------------------
/**
   necht "say" nejak sam vymysli, jak toto slovicko rici,
   ma na to svoje slovniky
   @param sayCmd command to run as text speaker
   @param slovicko word to say
 */
    void
Say::koktej(const char *sayCmd, const char *slovicko)
{
    const char *argv[] = {
        // argv[0] is the command name
        sayCmd,
        slovicko,
        // v poslednim agrv musi byt 0
        0
    };

    my_system(sayCmd, argv);
}
//-----------------------------------------------------------------------
/**
  Spusti zadanou binarku s parametry argv.
  Pocka az skonci a vrati navratovy status.
  */
    int 
Say::my_system(const char *command, const char *argv[])
{
    int pid;
    //int status;

    if (command == NULL) {
        return 1;
    }

    // zabijime zombie
    signal(SIGCHLD, SIG_IGN);

    pid = fork();
    if (pid == -1) {
        return -1;
    }
    if (pid ==0) {
        execvp(command, const_cast<char *const*>(argv));
        // chyba nelze spustit
        SysUtil::systemError(command);
    }

    // wait for the child
    do {
        int status;

        if (waitpid(pid, &status, 0) == -1) {
            if (errno != EINTR) {
                SysUtil::log_debug("waitpid: %s", strerror(errno));   
                return -1;
            }
        } else {
            return status;
        }
    } while(1);

}

