#ifndef SEARCH_H
#define SEARCH_H

#include "Compare.h"

#include <stdio.h>
#include <iconv.h>

/**
  Pro hledani slovicek se stejnym zacatkem.
  */
class Search {
    // velikost jednoho zaznamu v souboru
    static const long POLOZKA_W = 82;
    // nazev prohledavaneho souboru
    const char *filename;
    // poradove cislo prostredni polozky
    long middleset;
    // hledany zacatek retezce
    char *m_starts;
    // delka starts
    size_t m_len;
    char buffer[POLOZKA_W];
    FILE *file;
    // kolik slovicek vypisovat ve findList vzad a vpred
    int listVzad, listVpred;
    iconv_t m_inputCD;
    iconv_t m_outputCD;

    // porovnavac
    Compare *compare;

    private:
    void seekFile(const char *text);
    char *inputEncode(const char *text);
    char *outputEncode(const char *text);
    char *createEncoded(const char *text, iconv_t cd);
    bool checkMatch(const char *text, char *match);

    public:
    Search(Compare *cmp, const char *the_filename, 
            int vzad, int vpred, const char *encoding);
    ~Search();
    char *complete(const char *text);
    char *nextComplete();
    void findList(const char *text);
    void printMatches(const char *text);
};

#endif
