#include "StrUtil.h"
#include "SysUtil.h"

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

//-----------------------------------------------------------------
/**
  Orizne _koncove_ mezery.
  U vstupniho 'string' retezce, nastavi '\0' za posledni ne-mezeru.
  @param string retezec pro klonovani
  @param minlen minimalni velikost, vice uz se neorezava
  @return ukazatel na puvodni retezece
  */
    char *
StrUtil::trimstr(char *string, size_t minlen)
{
    char *t;

    /*
       for (s = string; isspace(*s); s++) {
    // nic
    }
    */
    t = string + strlen(string) - 1;
    while (t > string + minlen && isspace(*t)) {
        t--;
    }
    *++t = '\0';

    return string;
}

//-----------------------------------------------------------------
/**
  Zduplikuje retezec, vrati novou kopii vytvorenou pomoci malloc.
  @param string retezec pro klonovani
  @return kopie retezce
  */
    char *
StrUtil::dupstr(const char *string)
{
    char *r;

    r = (char *)SysUtil::xmalloc(strlen(string) + 1);
    strcpy(r, string);
    return r;
}

//-----------------------------------------------------------------
/**
  Spoji dva retezece.
  @param str1 prvni retezec
  @param str2 druhy retezec
  @return novy retezec obsahujici spojeny text
  */
    char *
StrUtil::concat(char *str1, const char *str2)
{
    char *r;

    r = (char *)SysUtil::xmalloc(strlen(str1) + strlen(str2) + 1);
    strcpy(r, str1);
    strcat(r, str2);
    return r;
}

//-----------------------------------------------------------------
/**
  Prevede retezec na male znaky.
  @param string pro zmenseni 
  */
    void
StrUtil::strlower(char *string)
{
    while (*string) {
        *string = tolower(*string);
        string++;
    }
}
