#include "SysUtil.h"

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include <readline/readline.h>

/*
   Initicalizace statickych prvku.
   */
const char *SysUtil::mProgName = "noname";

//-----------------------------------------------------------------
/*
   Pozmeneni progName objevujici se ve vypisech.
   */
    void 
SysUtil::initProgName(const char *name)
{
    mProgName = name;
}
//-----------------------------------------------------------------
/**
  Vrati jmeno programu.
  */
    const char *
SysUtil::getProgName()
{
    return mProgName;
}
//-----------------------------------------------------------------
/**
  Osetreny malloc.
  */
    void *
SysUtil::xmalloc(size_t size)
{
    void *mem;
    mem = malloc(size);
    if (mem == NULL) {
        SysUtil::systemError("malloc");
    }

    return mem;
}

//-----------------------------------------------------------------
/**
  Vypise chybove hlaseni dle errno
  a skonci.
  */

    void
SysUtil::systemError(const char *operation)
{
    error(operation, strerror(errno));
}
//-----------------------------------------------------------------
/**
  Vypise chybove hlaseni dle predane message
  a skonci.
  */
    void
SysUtil::error(const char *cause, const char *message)
{
    fprintf(stderr, "%s: error: (%s) %s\n", mProgName, cause, message);

    // vratime terminal do puvodniho stavu
    // mohli jsme prerusit readline() pri cteni
    rl_free_line_state();
    rl_cleanup_after_signal();

    exit(1);
}
//-----------------------------------------------------------------
/**
 * Vypise chybove hlaseni.
 */
    void
SysUtil::warning(const char *cause, const char *message)
{
    fprintf(stderr, "%s: warning: (%s) %s\n", mProgName, cause, message);
}

//-----------------------------------------------------------------
/**
  Vypise debug hlaseni.
  */
    void
SysUtil::log_debug(const char *fmt, ...)
{
#ifdef DEBUG
    va_list ap;

    fprintf(stderr, "DEBUG: ");
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
    fprintf(stderr, "\n");
#endif
}
