#ifndef SYSUTIL_H
#define SYSUTIL_H

#include <stdlib.h>

// disable gcc extension on other compilers
#ifndef __GNUC__
#define __attribute__(x)
#endif

class SysUtil {
    static const char *mProgName;
    static SysUtil initSysUtil;

    public:
    static void initProgName(const char *name);
    static const char *getProgName();
    static void *xmalloc(size_t size);
    static void systemError(const char *operation);
    static void error(const char *cause, const char *message);
    static void warning(const char *cause, const char *message);
    static void log_debug(const char *fmt, ...)
        __attribute__((format(__printf__, 1, 2)));
};

#endif
