#include "WbookConfig.h"

#include "Config.h"
#include "Options.h"
#include "SysUtil.h"
#include "StrUtil.h"

#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

/* 
   cesty ke slovnikum
   */
#ifndef DATADIR
#define DATADIR "./slovniky"
#endif

//-----------------------------------------------------------------
/**
  Z long_options sestavime short_options.
  Nastavi defaultni hodnoty.
  */
WbookConfig::WbookConfig(int iargc, char * const *iargv)
{
    argc = iargc;
    argv = iargv;

    Options *opt = new Options();
    opt->addParam(new Param("help",	false, "Display this help."));
    opt->addParam(new Param("version",	false, "Show version."));
    opt->addParam(new Param("dic",	true,  "Use given dictionary."));
    opt->addParam(new Param("abc",	true,  "Use given alphabet."));
    opt->addParam(new Param("quiet",	false, "Don't run say."));
    opt->addParam(new Param("back",	true,  "Print arg word back."));
    opt->addParam(new Param("forth",	true,  "Print arg word forth."));
    opt->addParam(new Param("say",	true,  "Say command to use."));
    opt->addParam(new Param("encoding",	true,  "Prefered input/output encoding."));
    opt->addParam(new Param("match",	false, "Return matches for given sentence."));
    config = new Config(opt);

    // defaultni hodnoty
    quiet = false;
    dic = DATADIR "/final.eng";
    abc = DATADIR "/abeceda.txt";
    back = 3;
    forth = 15;
    say = DATADIR "/wbook_say";
    encoding = "ISO-8859-2";

    parse();
}
//-----------------------------------------------------------------
WbookConfig::~WbookConfig()
{
    free(line);
    delete config;
}

//-----------------------------------------------------------------
/**
  Nacte vsechny parametry.
  */
    void
WbookConfig::parse()
{
    while (true) {
        int next_option = config->getNextVal(argc, argv);

        switch (next_option) {
            case 'h': 
                // help
                printUsage(stdout, 0);
            case 'v': 
                // version
                printVersion();

            case 'd':
                // dic
                //FIXME: nemel by se obsah optarg zkopirovat?
                dic = optarg;
                break;
            case 'a':
                // abc
                abc = optarg;
                break;
            case 'q':
                // quiet
                quiet = true;
                break;
            case 'b':
                // back
                back = atoi(optarg);
                if (back < 0) {
                    back = 0;
                }
                break;
            case 'f':
                // forth
                forth = atoi(optarg);
                if (forth <= 0) {
                    forth = 1;
                }
                break;
            case 's':
                // say
                say = optarg;
                break;
            case 'e':
                // encoding
                encoding = optarg;
                break;
            case 'm':
                // match
                match = true;
                break;
            case '?':
                // unknown options
                printUsage(stderr, 1);
            case -1:
                // end of params
                storeLine();

                // konec parsovani
                return;
            default:
                SysUtil::error("getNextVal", "bad next_option");
        }
    }
}
//-----------------------------------------------------------------
/**
 * Ulozi zbytek parametru do line
 * optind ... externi promenna ukazujici na prvni
 * argv-element, ktery nepatri k options
 */
    void
WbookConfig::storeLine()
{
    // na pocatku je prazdny retezec
    line = (char *)SysUtil::xmalloc(1);
    line[0] = '\0';

    for (int i = optind; i < argc; i++) {
        char *newline;

        if (i > optind) {
            // mezislovni mezera
            newline = StrUtil::concat(line, " ");
            free(line);
            line = newline;
        }

        newline = StrUtil::concat(line, argv[i]);
        free(line);
        line = newline;
    }
}

//-----------------------------------------------------------------
/**
  Vypise nastaveni.
  */
    void
WbookConfig::printConfig()
{
    printf("\n--=  Configuration  =--\n");
    printf("dic:     %s\n", dic);
    printf("abc:     %s\n", abc);
    printf("quiet:   %s\n", quiet ? "true" : "false");
    printf("back:    %d\n", back);
    printf("forth:   %d\n", forth);
    printf("say:     %s\n", say);
    printf("encoding:%s\n", encoding);
}
//-----------------------------------------------------------------
/**
  Vypise help a skonci.
  */
    void
WbookConfig::printUsage(FILE *out, int exitcode)
{
    config->printUsage(out);
    printConfig();

    exit(exitcode);
}
//-----------------------------------------------------------------
/**
  Vypise verzi a skonci.
  */
    void
WbookConfig::printVersion()
{
    const char *version = "0.0.1";
#ifdef VERSION
    version = VERSION;
#endif
    printf("%s: version=%s\n", SysUtil::getProgName(), version);
    exit(0);
}


//-----------------------------------------------------------------
    const char *
WbookConfig::getDic()
{
    return dic;
}
//-----------------------------------------------------------------
    const char *
WbookConfig::getABC()
{
    return abc;
}
//-----------------------------------------------------------------
    bool 
WbookConfig::getQuiet()
{
    return quiet;
}
//-----------------------------------------------------------------
    int 
WbookConfig::getBack()
{
    return back;
}
//-----------------------------------------------------------------
    int 
WbookConfig::getForth()
{
    return forth;
}
//-----------------------------------------------------------------
    const char *
WbookConfig::getSay()
{
    return say;
}
//-----------------------------------------------------------------
    const char *
WbookConfig::getEncoding()
{
    return encoding;
}
//-----------------------------------------------------------------
    bool
WbookConfig::getMatch()
{
    return match;
}
//-----------------------------------------------------------------
    const char *	
WbookConfig::argLine()
{
    return line;
}



