#ifndef WBOOKCONFIG_H
#define WBOOKCONFIG_H

class Config;

#include <stdio.h>

/**
  Konfigurace pro wbook.
  */
class WbookConfig {
    Config *config;
    // hodnoty options
    char *dic;
    char *abc;
    bool quiet;
    int back;
    int forth;
    char *say;
    char *encoding;
    bool match;
    char *line;

    int argc;
    char * const *argv;

    private:
    void parse();
    void printUsage(FILE *out, int exitcode);
    void printVersion();
    void storeLine();

    public:
    WbookConfig(int iargc, char * const *iargv);
    ~WbookConfig();
    void printConfig();
    const char *getDic();
    const char *getABC();
    bool getQuiet();
    int getBack();
    int getForth();
    const char *getSay();
    const char *getEncoding();
    bool getMatch();
    const char *argLine();
};

#endif
