#include "SysUtil.h"
#include "Commander.h"
#include "Search.h"
#include "Say.h"
#include "WbookConfig.h"
#include "Compare.h"

#include <stdio.h>
#include <string.h> //strlen

//-----------------------------------------------------------------
/**
  Zkouska doplnovani pomoci readline.
  */
    int
main(int argc, char *argv[])
{
    Commander *cmd;
    Search *search;
    Compare *compare;

    SysUtil::initProgName(argv[0]);
    WbookConfig *config = new WbookConfig(argc, argv);

#ifdef DEBUG
    config->printConfig();
#endif

    compare = new Compare(config->getABC());
    search = new Search(compare, config->getDic(),
            config->getBack(), config->getForth(), config->getEncoding());
    if (config->getMatch()) {
        search->printMatches(config->argLine());
        return 0;
    }

    cmd = new Commander(search);

    const char *argline = config->argLine();
    if (strlen(argline) > 0) {
        cmd->inputLine(argline);
    }

    while (true) {
        char *line = cmd->runLine();

        //printf("zadano: %s\n", line);
        search->findList(line);

        if (config->getQuiet() != true) {
            Say::koktej(config->getSay(), line);
        }
    }

    // nikdy sem nedojde, skonci na ctrl-d (konec vstupu).
    delete cmd;
    delete search;
    delete compare;
    delete config;
    return 0;
}

